/* eslint-env node */
module.exports = ({ getCard, getLinkedCardUserList, _, sendMessageToChannel }) => {
  const AtUserPattern = /<at id="(\d+)"\/>/g
  const at = id => `<at id="${id}"/>`

  function getAtUserCardList(content, env) {
    // 兼容代骰，不完全严谨
    if (env.realUser.userId !== env.userId) {
      content = (content || '') + at(env.userId)
    }
    // 获取所有 @ 成员 id
    const ids = content ? Array.from(content.matchAll(AtUserPattern)).map(i => i[1]) : getLinkedCardUserList(env)
    const uniqIds = Array.from(new Set(ids))
    const userCards = uniqIds
      .map(userId => ({ userId, card: getCard({ ...env, userId }) }))
      .filter(({ card }) => card && card.type === 'coc')
    return userCards
  }

  function sortByDex(userCards) {
    userCards.forEach(item => {
      item.dex = item.card.getEntry('敏捷').value
      item.seed = Math.floor(Math.random() * (10**14)) // < MAX_SAFE_INTEGER
    })
    const result = _.orderBy(userCards, 'dex', 'desc')
    // 最终排序结果，由于触发对抗一定是 dex 相同，故掷骰结果就决定了胜负
    const finalResult = _.orderBy(userCards, ['dex', 'seed'], ['desc', 'asc'])
    return [result, finalResult]
  }

  function getVsGroups(list, round = 0) {
    // round 0 - 判断敏捷值相等，else 判断对抗检定数值相等
    const groupByKey = round === 0 ? 'dex' : item => `${item.dex}+${item.vs.roll}`
    const groups = Object.values(_.groupBy(list, groupByKey))
    return groups.filter(group => group.length > 1) // [[a, b], [c, d, e]]
  }

  const successLevels = Object.freeze({
    '-2': '大失败',
    '-1': '失败',
    '1': '成功',
    '2': '困难成功',
    '3': '极难成功',
    '4': '大成功'
  })

  function vs(vsGroups, round) {
    let result = round === 1 ? '对抗结果：' : `第${round}轮对抗结果：`
    vsGroups.forEach(group => {
      group.forEach(item => {
        const roll = Math.floor(item.seed / (10**(14-round*2)) % 100) + 1
        const target = item.dex
        item.vs = { roll, target, level: decideByCoc0(roll, target) }
      })
      const body = group.map(item => `[${item.card.name}] ${item.vs.roll}/${item.vs.target} ${successLevels[item.vs.level]}`).join('\n')
      result += '\n' + body
      // 找出对抗胜者
      const lowest = findLowestRoll(group)
      if (lowest.length === 1) {
        result += `\n此次对抗[${lowest[0].card.name}]取得胜利`
      }
    })
    // 组装 result
    return result + '\n'
  }

  function decideByCoc0(roll, baseValue, targetValue = baseValue) {
    if ((baseValue < 50 && roll > 95) || (baseValue >= 50 && roll === 100)) return -2
    if (roll === 1) return 4
    if (roll > targetValue) return -1
    if (roll <= targetValue && roll <= baseValue / 5) return 3
    if (roll <= targetValue && roll <= baseValue / 2) return 2
    return 1
  }

  function findLowestRoll(list) {
    const ret = []
    let lowest = Infinity
    list.forEach(item => {
      const roll = item.vs.roll
      if (roll < lowest) {
        lowest = roll
        ret.length = 0
        ret.push(item)
      } else if (roll === lowest) {
        ret.push(item)
      }
    })
    return ret
  }

  return {
    id: 'io.paotuan.plugin.coc.ttmj',
    name: 'COC 团体敏捷',
    version: 3,
    customReply: [
      {
        id: 'ttmj',
        name: 'COC 团体敏捷',
        description: '/ttmj @aaa @bbb 指定成员根据敏捷高低排序，若敏捷相同则进行对抗检定；适用于追逐轮。省略 @ 则取所有关联了 COC 人物卡的成员排序',
        command: '^\\s*ttmj\\s*(?<content>.*)',
        trigger: 'regex',
        handler(env, { content }) {
          const userCards = getAtUserCardList(content, env)
          if (userCards.length === 0) {
            return '没有关联 COC 人物卡的成员'
          }
          // 根据敏捷排序
          const [result, finalResult] = sortByDex(userCards)
          let vsGroups = getVsGroups(result, 0)
          let vsResult = ''
          let round = 1
          while (vsGroups.length > 0) {
            if (round >= 7) break // 禁止大于 7 轮
            vsResult += vs(vsGroups, round++)
            vsGroups = getVsGroups(vsGroups.flat(), round) // 第二轮的 vsGroup 只从第一轮对抗过的里面判断就好
          }
          // reply
          const dexList = result.map(item => `${item.card.name} [${item.dex}]`).join('\n')
          let reply = `团体敏捷列表：\n${dexList}`
          // 是否有对抗，区别处理
          if (vsResult.length > 0) {
            // 直接发有时序问题，await 下
            (async () => {
              reply += '\n' + vsResult
              await sendMessageToChannel(env, reply)
              const finalDexList = finalResult.map(item => `${item.card.name} [${item.dex}]`).join('\n')
              sendMessageToChannel(env, `最终敏捷列表：\n${finalDexList}`)
            })()
            return ''
          } else {
            return reply
          }
        }
      }
    ]
  }
}
